'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Button_AllesLoeschen_Click()
    Dim dbs As Database
    Dim rst As Recordset

    'Sicherheitsfrage
    If MsgBox("Sollen alle Kategorien aus der Vorgabeliste gelscht werden?", vbYesNo + vbQuestion + vbDefaultButton2, "Liste leeren") <> vbYes Then
        Exit Sub
    End If
    
    On Error GoTo 0
    
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    If rst.RecordCount > 0 Then
        rst.MoveLast
        Do While Not rst.BOF
            rst.Delete
            rst.MovePrevious
        Loop
    End If
    
    rst.Close
    Set dbs = Nothing
    
    'Anzeige aktualisieren
    Me.Requery
    
End Sub

Private Sub Button_NeueKategorievorgabe_Click()
On Error GoTo Err_Button_NeueKategorievorgabe_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
          
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_6"
    ''FormularBereich = "Steuersaetze"
    
    'Eigentliches Formular ffnen
    stDocName = "Kategorievorgaben_neu"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
        
Exit_Button_NeueKategorievorgabe_Click:
    Exit Sub

Err_Button_NeueKategorievorgabe_Click:
    MsgBox err.Description
    Resume Exit_Button_NeueKategorievorgabe_Click

End Sub

Private Sub Button_KategorievorgabeLoeschen_Click()
    On Error GoTo ERROR_Button_KategorievorgabeLoeschen_Click

    Dim dbs As Database
    Dim rst As Recordset
    Dim strFilter As String
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_6"
    ''FormularBereich = "Steuersaetze"
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'wenn Datensatz vorhanden, dann lschen...
    If (rst.RecordCount = 0) Then
        Set dbs = Nothing
        MsgBox "Keine Kategorievorgaben vorhanden.", vbInformation, "Hinweis"
    Else
        strFilter = "SELECT * FROM Kategorievorgaben WHERE [lfd_Nr] = " & AktKategorie
        Set rst = dbs.OpenRecordset(strFilter)
        If MsgBox("Ausgewhlte Kategorievorgabe [" & rst!Kategorie & "] wirklich lschen?", vbYesNo + vbQuestion + vbDefaultButton2, "Kategorievorgabe lschen...") = vbNo Then
            rst.Close
            Set dbs = Nothing
            Exit Sub
        End If
        rst.Delete
        rst.Requery
        rst.Close
        Set dbs = Nothing
        
        'Anzeige aktualisieren
        Me.Requery
    
    End If
    
EXIT_Button_KategorievorgabeLoeschen_Click:
    Exit Sub
    
ERROR_Button_KategorievorgabeLoeschen_Click:
    MsgBox err.Description
    Resume EXIT_Button_KategorievorgabeLoeschen_Click
    
End Sub

Private Sub Form_Current()
    AktKategorie = Me.lfd_Nr.Value
End Sub
